const express = require("express");
const path = require("path");
const https = require("https");

const app = express();
const API_KEY = "API_KEY_HERE";

app.use(express.static(path.join(__dirname, "public")));

app.get("/weather", (req, res) => {
  const city = (req.query.city || "").trim();
  console.log("Request for city:", city);

  if (city === "") {
    return res.status(400).json({ error: "Please enter a city name." });
  }

  const url =
    "https://api.openweathermap.org/data/2.5/weather?q=" +
    encodeURIComponent(city) +
    "&appid=" +
    API_KEY +
    "&units=metric";

  https
    .get(url, (apiRes) => {
      let data = "";

      apiRes.on("data", (chunk) => {
        data += chunk;
      });

      apiRes.on("end", () => {
        try {
          const json = JSON.parse(data);

          if (json.cod === "404" || json.cod === 404) {
            return res
              .status(404)
              .json({ error: "City not found. Please try another city." });
          }

          const result = {
            city: json.name,
            country: json.sys && json.sys.country,
            temp: json.main && json.main.temp,
            feelsLike: json.main && json.main.feels_like,
            description:
              json.weather && json.weather[0] && json.weather[0].description,
            icon: json.weather && json.weather[0] && json.weather[0].icon,
            humidity: json.main && json.main.humidity,
            wind: json.wind && json.wind.speed
          };

          res.json(result);
        } catch (err) {
          res
            .status(500)
            .json({ error: "Error reading weather data. Please try again." });
        }
      });
    })
    .setTimeout(5000, function () {
    this.destroy();
    res
      .status(504)
      .json({ error: "Weather service is taking too long. Try again." });
  })
    .on("error", () => {
      res
        .status(500)
        .json({ error: "Could not reach weather service. Try again later." });
    });
});

const PORT = process.env.PORT || 3000;

app.listen(PORT, () => {
  console.log(" open in the Local:  http://localhost:" + PORT);
});
