const searchBtn = document.getElementById("searchBtn");
const cityInput = document.getElementById("cityInput");

const errorMsg = document.getElementById("errorMsg");
const resultCard = document.getElementById("resultCard");

const locationEl = document.getElementById("location");
const descEl = document.getElementById("desc");
const tempEl = document.getElementById("temp");
const feelsEl = document.getElementById("feels");
const humidityEl = document.getElementById("humidity");
const windEl = document.getElementById("wind");
const iconEl = document.getElementById("icon");

searchBtn.addEventListener("click", async () => {
  const city = cityInput.value.trim();

  errorMsg.textContent = "";
  resultCard.classList.add("hidden");

  if (city === "") {
    errorMsg.textContent = "Please enter a city name.";
    return;
  }

  try {
    const res = await fetch("/weather?city=" + encodeURIComponent(city));
    const data = await res.json();

    if (data.error) {
      errorMsg.textContent = data.error;
      return;
    }

    locationEl.textContent = `${data.city}, ${data.country}`;
    descEl.textContent = data.description;
    tempEl.textContent = Math.round(data.temp);
    feelsEl.textContent = Math.round(data.feelsLike);
    humidityEl.textContent = data.humidity;
    windEl.textContent = data.wind;

    if (data.icon) {
      iconEl.src = `https://openweathermap.org/img/wn/${data.icon}@2x.png`;
      iconEl.style.display = "inline-block";
    } else {
      iconEl.style.display = "none";
    }

    resultCard.classList.remove("hidden");
  } catch {
    errorMsg.textContent = "Something went wrong. Please try again.";
  }
});
